var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var Logger = (function () {
                function Logger() {
                    this._loggerProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.LoggerPortMarshaler", {
                    }, true);
                }
                Logger.prototype.info = function (message) {
                    this._loggerProxy._call("logInfo", message);
                };
                Logger.prototype.debug = function (message) {
                    this._loggerProxy._call("logDebug", message);
                };
                Logger.prototype.warning = function (message) {
                    this._loggerProxy._call("logWarning", message);
                };
                Logger.prototype.error = function (message) {
                    this._loggerProxy._call("logError", message);
                };
                return Logger;
            })();            
            var _logger = null;
            function getLogger() {
                if(_logger == null) {
                    _logger = new Logger();
                }
                return _logger;
            }
            DiagnosticsHub.getLogger = getLogger;
            Plugin.addEventListener("pluginready", function () {
                getLogger();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            (function (SessionState) {
                SessionState._map = [];
                SessionState.Unknown = 0;
                SessionState.Created = 100;
                SessionState.LaunchConfiguration = 125;
                SessionState.SetupTargets = 150;
                SessionState.CollectionStarting = 200;
                SessionState.CollectionStarted = 300;
                SessionState.CollectionPausing = 325;
                SessionState.CollectionPauseCanceling = 330;
                SessionState.CollectionPaused = 350;
                SessionState.CollectionResuming = 375;
                SessionState.CollectionResumeCanceling = 380;
                SessionState.CollectionFinishing = 400;
                SessionState.CollectionFinished = 500;
                SessionState.CollectionTerminating = 600;
                SessionState.CollectionTerminated = 700;
                SessionState.CollectionStartFailed = 10000;
                SessionState.CollectionStartCanceling = 10100;
                SessionState.CollectionFinishFailed = 20000;
                SessionState.CollectionFinishCanceling = 20100;
                SessionState.SessionClosed = 100000;
            })(DiagnosticsHub.SessionState || (DiagnosticsHub.SessionState = {}));
            var SessionState = DiagnosticsHub.SessionState;
            var EventDeferral = (function () {
                function EventDeferral(onHandlerCompleted) {
                    this._onHandlerCompleted = onHandlerCompleted;
                }
                EventDeferral.prototype.complete = function () {
                    this._onHandlerCompleted();
                };
                return EventDeferral;
            })();            
            var StateChangedEventArgs = (function () {
                function StateChangedEventArgs(eventArgs, onHandlerCompleted) {
                    this._eventArgs = eventArgs;
                    this._waitHandler = false;
                    this._onHandlerCompleted = onHandlerCompleted;
                    this._eventDeferral = null;
                }
                Object.defineProperty(StateChangedEventArgs.prototype, "currentState", {
                    get: function () {
                        return this._eventArgs.CurrentState;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(StateChangedEventArgs.prototype, "previousState", {
                    get: function () {
                        return this._eventArgs.PreviousState;
                    },
                    enumerable: true,
                    configurable: true
                });
                StateChangedEventArgs.prototype.getDeferral = function () {
                    if(this._eventDeferral == null) {
                        this._eventDeferral = new EventDeferral(this._onHandlerCompleted);
                    }
                    return this._eventDeferral;
                };
                Object.defineProperty(StateChangedEventArgs.prototype, "waitHandler", {
                    get: function () {
                        return this._eventDeferral != null;
                    },
                    enumerable: true,
                    configurable: true
                });
                return StateChangedEventArgs;
            })();            
            var Session = (function () {
                function Session(logger) {
                    var that = this;
                    this._eventsListeners = new Array();
                    this._logger = logger;
                    this._sessionProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.SessionPortMarshaler", {
                    }, true);
                    this._sessionProxy._call("initialize").done(function () {
                        that._logger.debug("JavaScript session object connected to host. Ready to get session state notification events.");
                    }, function (error) {
                        that._logger.error("Cannot initialize session, error name: '" + error.name + "', error message: '" + error.message + "'");
                    });
                    this._sessionProxy.addEventListener("sessionStateChanged", function (eventArgs) {
                        that.stateChangedHandler(eventArgs);
                    });
                    try  {
                        var apex = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.Test.Apex.DiagnosticsHub.ApexJSExtension", {
                        }, true);
                        if(apex != null) {
                            apex._call("getApexJavaScript").done(function (result) {
                                var scriptObj = document.createElement("script");
                                scriptObj.setAttribute("type", "text/javascript");
                                scriptObj.setAttribute("src", result);
                                var head = document.getElementsByTagName("head");
                                if(!head) {
                                    that._logger.debug("Unable to add apex script to document");
                                } else {
                                    head[0].appendChild(scriptObj);
                                    that._logger.debug("Added ApexJSExtension '" + result + "' to document");
                                }
                            });
                        }
                    } catch (e) {
                        this._logger.error(e.toString());
                    }
                }
                Session.prototype.getState = function (callback, onError) {
                    var that = this;
                    this._logger.debug("Calling get state");
                    return this._sessionProxy._call("getState").done(function (result) {
                        that._logger.debug("On getstate done, state value: " + result);
                        if(callback != null) {
                            callback(result);
                        }
                    }, function (error) {
                        that._logger.error("Cannot get state, error name: '" + error.name + "', error message: '" + error.message + "'");
                        if(onError != null) {
                            onError(error);
                        }
                    });
                };
                Session.prototype.addStateChangedEventListener = function (listener) {
                    this._eventsListeners.push(listener);
                    this._logger.debug('State changed event handler added.');
                };
                Session.prototype.removeStateChangedEventListener = function (listener) {
                    for(var i = 0; i < this._eventsListeners.length; i++) {
                        if(this._eventsListeners[i] == listener) {
                            this._logger.debug('State changed event handler removed.');
                            this._eventsListeners.splice(i, 1);
                            break;
                        }
                    }
                };
                Session.prototype.stateChangedHandler = function (eventArgs) {
                    var that = this;
                    this._logger.debug('Invoking JavaScript handlers for State Change Event.');
                    var handlersCount = 0;
                    var onCompleted = function () {
                        handlersCount--;
                        if(handlersCount <= 0) {
                            that._sessionProxy._call("sessionStateChangedCompleted", eventArgs.Token);
                        } else {
                            that._logger.debug("Still waiting when all event state change handlers will complete their work. Handlers count: " + handlersCount);
                        }
                    };
                    for(var propertyName in this._eventsListeners) {
                        var handler = this._eventsListeners[propertyName];
                        if(this._eventsListeners.hasOwnProperty(propertyName)) {
                            if(typeof handler == 'function') {
                                try  {
                                    var jsEventArgs = new StateChangedEventArgs(eventArgs, onCompleted);
                                    handler(jsEventArgs);
                                    if(jsEventArgs.waitHandler) {
                                        handlersCount++;
                                        that._logger.debug("JavaScipt handlers for event state changed asked to wait while they will finish. Handlers count: " + handlersCount);
                                    }
                                } catch (e) {
                                    this._logger.error(e.toString());
                                }
                            } else {
                                this._logger.warning('One of the listeners not a "function", it has type ' + (typeof handler));
                            }
                        }
                    }
                    if(handlersCount == 0) {
                        onCompleted();
                    }
                };
                return Session;
            })();            
            var _currentSession = null;
            function getCurrentSession() {
                if(_currentSession == null) {
                    _currentSession = new Session(DiagnosticsHub.getLogger());
                }
                return _currentSession;
            }
            DiagnosticsHub.getCurrentSession = getCurrentSession;
            Plugin.addEventListener("pluginready", function () {
                getCurrentSession();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var EventAggregator = (function () {
                function EventAggregator(logger) {
                    this._eventsListeners = {
                    };
                    var that = this;
                    this._logger = logger;
                    this._eventAggregatorProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.EventAggregatorMarshaler", {
                    }, true);
                    this._eventAggregatorProxy.addEventListener("globalEventHandler", function (eventArgs) {
                        that.globalEventHandler(eventArgs);
                    });
                }
                EventAggregator.prototype.addEventListener = function (eventType, listener) {
                    if(typeof this._eventsListeners[eventType] == 'undefined') {
                        this._eventsListeners[eventType] = new Array();
                    }
                    this._eventsListeners[eventType].push(listener);
                    this._logger.debug('Event listener added.');
                };
                EventAggregator.prototype.removeEventListener = function (eventType, listener) {
                    if(typeof this._eventsListeners[eventType] != 'undefined') {
                        var subscribers = this._eventsListeners[eventType];
                        for(var i = 0; i < subscribers.length; i++) {
                            if(subscribers[i] == listener) {
                                this._logger.debug('Event listener removed.');
                                subscribers.splice(i, 1);
                                break;
                            }
                        }
                        if(subscribers.length == 0) {
                            delete this._eventsListeners[eventType];
                        }
                    }
                };
                EventAggregator.prototype.globalEventHandler = function (eventArgs) {
                    var eventType = eventArgs.EventType;
                    this._logger.debug('Handling event type ' + eventType + '.');
                    var listeners = this._eventsListeners[eventType];
                    if(typeof listeners != 'undefined') {
                        for(var propertyName in listeners) {
                            var handler = listeners[propertyName];
                            if(listeners.hasOwnProperty(propertyName)) {
                                if(typeof handler == 'function') {
                                    var dataString = eventArgs.HubEventArgs.Data;
                                    this._logger.debug('Raise handler for event type ' + eventType + ' with data ' + dataString + '.');
                                    try  {
                                        var data = null;
                                        if(dataString != null) {
                                            data = JSON.parse(dataString);
                                        }
                                        handler(data);
                                    } catch (e) {
                                        this._logger.error(e);
                                    }
                                } else {
                                    this._logger.warning('One of the listeners not a "function", it has type ' + (typeof handler));
                                }
                            }
                        }
                    } else {
                        this._logger.debug('Does not have listeners for event type ' + eventType + '.');
                    }
                };
                EventAggregator.prototype.raiseEvent = function (eventType, data) {
                    var dataString = null;
                    if(data != null) {
                        dataString = JSON.stringify(data);
                    }
                    this._logger.debug('Raising event type ' + eventType + ' with data ' + dataString + '.');
                    this._eventAggregatorProxy._call("raiseEvent", eventType, dataString);
                };
                return EventAggregator;
            })();            
            var _eventAggregator = null;
            function getEventAggregator() {
                if(_eventAggregator == null) {
                    _eventAggregator = new EventAggregator(DiagnosticsHub.getLogger());
                }
                return _eventAggregator;
            }
            DiagnosticsHub.getEventAggregator = getEventAggregator;
            Plugin.addEventListener("pluginready", function () {
                getEventAggregator();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var OutputWindowsService = (function () {
                function OutputWindowsService() {
                    this._loggerProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.OutputWindowServiceMarshaler", {
                    }, true);
                }
                OutputWindowsService.prototype.outputLine = function (message) {
                    this._loggerProxy._call("outputLine", message);
                };
                OutputWindowsService.prototype.outputLineAndShow = function (message) {
                    this._loggerProxy._call("outputLineAndShow", message);
                };
                OutputWindowsService.prototype.outputString = function (message) {
                    this._loggerProxy._call("outputString", message);
                };
                OutputWindowsService.prototype.outputStringAndShow = function (message) {
                    this._loggerProxy._call("outputStringAndShow", message);
                };
                return OutputWindowsService;
            })();            
            var _outputWindowService = null;
            function getOutputWindowsService() {
                if(_outputWindowService == null) {
                    _outputWindowService = new OutputWindowsService();
                }
                return _outputWindowService;
            }
            DiagnosticsHub.getOutputWindowsService = getOutputWindowsService;
            Plugin.addEventListener("pluginready", function () {
                getOutputWindowsService();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            (function (Collectors) {
                "use strict";
                var StandardTransportService = (function () {
                    function StandardTransportService(logger) {
                        var that = this;
                        this._messageListeners = {
                        };
                        this._logger = logger;
                        this._proxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.StandardTransportServicePortMarshaller", {
                        }, true);
                        this._proxy.addEventListener("stringMessageReceived", function (eventArgs) {
                            that._logger.debug("StandardTransportService.stringMessageReceived");
                            that.onStringMessageReceived(eventArgs);
                        });
                    }
                    StandardTransportService.prototype.getIsRemoteConnection = function () {
                        return this._proxy._call("getIsRemoteConnection");
                    };
                    StandardTransportService.prototype.sendStringToCollectionAgent = function (agentClassId, request) {
                        this._logger.debug("StandardTransportService.sendStringToCollectionAgent");
                        return this._proxy._call("sendStringToCollectionAgent", agentClassId, request);
                    };
                    StandardTransportService.prototype.downloadFile = function (targetFilePath, localFilePath) {
                        this._logger.debug("StandardTransportService.downloadFile");
                        return this._proxy._call("downloadFile", targetFilePath, localFilePath);
                    };
                    StandardTransportService.prototype.addMessageListener = function (listenerGuid, listener) {
                        var _this = this;
                        this._logger.debug("StandardTransportService.addMessageListener(" + listenerGuid + ")");
                        if(typeof listenerGuid != "string" || (listenerGuid.length != 38 && listenerGuid.length != 36)) {
                            throw new Error("'listenerGuid' must be a Guid string");
                        }
                        if(listenerGuid.length == 38 && listenerGuid[0] == '{' && listenerGuid[37] == '}') {
                            listenerGuid = listenerGuid.substr(1, 36);
                        }
                        listenerGuid = listenerGuid.toLowerCase();
                        var lowerCaseGuidRegEx = new RegExp("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
                        if(!lowerCaseGuidRegEx.test(listenerGuid)) {
                            throw new Error("'listenerGuid' must be a Guid string");
                        }
                        if(this._messageListeners[listenerGuid]) {
                            throw new Error("Listener already exists with guid = " + listenerGuid);
                        }
                        this._messageListeners[listenerGuid] = listener;
                        return this._proxy._call("enableEventsForListenerId", listenerGuid).then(null, function (value) {
                            _this._messageListeners[listenerGuid] = null;
                        });
                    };
                    StandardTransportService.prototype.onStringMessageReceived = function (eventArgs) {
                        this._logger.debug('StandardTransportService.onStringMessageReceived');
                        var listenerGuid = eventArgs.ListenerId;
                        var message = eventArgs.Message;
                        if(this._messageListeners[listenerGuid]) {
                            var listener = this._messageListeners[listenerGuid];
                            listener(message);
                        } else {
                            this._logger.warning('Unexpected message recieved without a message listener. listenerGuid=' + listenerGuid);
                        }
                    };
                    return StandardTransportService;
                })();                
                var _standardTransportService = null;
                function getStandardTransportService() {
                    if(_standardTransportService == null) {
                        _standardTransportService = new StandardTransportService(DiagnosticsHub.getLogger());
                    }
                    return _standardTransportService;
                }
                Collectors.getStandardTransportService = getStandardTransportService;
            })(DiagnosticsHub.Collectors || (DiagnosticsHub.Collectors = {}));
            var Collectors = DiagnosticsHub.Collectors;
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var GraphDataUpdateService = (function () {
                function GraphDataUpdateService(logger) {
                    this._logger = logger;
                    this._serviceProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.GraphDataUpdateServiceMarshaler", {
                    }, true);
                }
                GraphDataUpdateService.prototype.addNewPoints = function (counterId, points) {
                    var that = this;
                    this._serviceProxy._call("addNewPoints", counterId, points).done(function () {
                    }, function (error) {
                        that._logger.error(error.message);
                    });
                };
                return GraphDataUpdateService;
            })();            
            var _graphDataUpdateService = null;
            function getGraphDataUpdateService() {
                if(_graphDataUpdateService == null) {
                    _graphDataUpdateService = new GraphDataUpdateService(DiagnosticsHub.getLogger());
                }
                return _graphDataUpdateService;
            }
            DiagnosticsHub.getGraphDataUpdateService = getGraphDataUpdateService;
            Plugin.addEventListener("pluginready", function () {
                getGraphDataUpdateService();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            (function (DataWarehouse) {
                "use strict";
                var DataSourceIdentity = (function () {
                    function DataSourceIdentity() { }
                    DataSourceIdentity.EtlFile = "DiagnosticsHub.FileDataSource.EtlFile";
                    DataSourceIdentity.DiagnosticsPackage = "DiagnosticsHub.FileDataSource.DiagnosticsPackage";
                    DataSourceIdentity.Directory = "DiagnosticsHub.FileDataSource.Directory";
                    DataSourceIdentity.UnknownFile = "DiagnosticsHub.FileDataSource.UnknownFile";
                    return DataSourceIdentity;
                })();
                DataWarehouse.DataSourceIdentity = DataSourceIdentity;                
                (function (DataSourceInfoType) {
                    DataSourceInfoType._map = [];
                    DataSourceInfoType.Unknown = 0;
                    DataSourceInfoType.File = 1;
                    DataSourceInfoType.Directory = 2;
                    DataSourceInfoType.Package = 3;
                })(DataWarehouse.DataSourceInfoType || (DataWarehouse.DataSourceInfoType = {}));
                var DataSourceInfoType = DataWarehouse.DataSourceInfoType;
                var DataSourceInfo = (function () {
                    function DataSourceInfo(id, type, identity, path) {
                        this.id = id;
                        this.type = type;
                        this.identity = identity;
                        this.path = path;
                    }
                    return DataSourceInfo;
                })();
                DataWarehouse.DataSourceInfo = DataSourceInfo;                
                var DataWarehouseService = (function () {
                    function DataWarehouseService() {
                        this._serviceProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DataWarehouseServiceMarshaler", {
                        }, true);
                        this._logger = DiagnosticsHub.getLogger();
                    }
                    DataWarehouseService.prototype.getAllDataSourceInfos = function (callback) {
                        var that = this;
                        this._serviceProxy._call("getAllDataSourceInfos").done(function (result) {
                            var infos = new Array();
                            for(var i = 0; i < result.length; i++) {
                                var dataSource = result[i];
                                if(dataSource.Type == DataSourceInfoType.File || dataSource.Type == DataSourceInfoType.Directory || dataSource.Type == DataSourceInfoType.Package) {
                                    infos.push(new DataSourceInfo(dataSource.Id, dataSource.Type, dataSource.Identity, dataSource.Path));
                                } else {
                                    that._logger.error("Unknown type of data source info type: " + dataSource.Type);
                                }
                            }
                            callback(infos);
                        });
                    };
                    return DataWarehouseService;
                })();                
                var _service = null;
                function getDataWarehouseService() {
                    if(_service == null) {
                        _service = new DataWarehouseService();
                    }
                    return _service;
                }
                DataWarehouse.getDataWarehouseService = getDataWarehouseService;
                Plugin.addEventListener("pluginready", function () {
                    getDataWarehouseService();
                });
            })(DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
            var DataWarehouse = DiagnosticsHub.DataWarehouse;
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
//@ sourceMappingURL=DiagnosticsHub.js.map

// SIG // Begin signature block
// SIG // MIIaqwYJKoZIhvcNAQcCoIIanDCCGpgCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFJSq0HvJE0QS
// SIG // eDtP7bKTs32Hlf1joIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AAArOTJIwbLJSPMAAAAAACswDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTEyMDkwNDIx
// SIG // MTIzNFoXDTEzMTIwNDIxMTIzNFowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKa2MA4DZa5QWoZrhZ9IoR7JwO5eSQeF4HCWfL65
// SIG // X2JfBibTizm7GCKlLpKt2EuIOhqvm4OuyF45jMIyexZ4
// SIG // 7Tc4OvFi+2iCAmjs67tAirH+oSw2YmBwOWBiDvvGGDhv
// SIG // sJLWQA2Apg14izZrhoomFxj/sOtNurspE+ZcSI5wRjYm
// SIG // /jQ1qzTh99rYXOqZfTG3TR9X63zWlQ1mDB4OMhc+LNWA
// SIG // oc7r95iRAtzBX/04gPg5f11kyjdcO1FbXYVfzh4c+zS+
// SIG // X+UoVXBUnLjsfABVRlsomChWTOHxugkZloFIKjDI9zMg
// SIG // bOdpw7PUw07PMB431JhS1KkjRbKuXEFJT7RiaJMCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBSlGDNTP5VgoUMW747G
// SIG // r9Irup5Y0DAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQB+zLB75S++
// SIG // 51a1z3PbqlLRFjnGtM361/4eZbXnSPObRogFZmomhl7+
// SIG // h1jcxmOOOID0CEZ8K3OxDr9BqsvHqpSkN/BkOeHF1fnO
// SIG // B86r5CXwaa7URuL+ZjI815fFMiH67holoF4MQiwRMzqC
// SIG // g/3tHbO+zpGkkSVxuatysJ6v5M8AYolwqbhKUIzuLyJk
// SIG // pajmTWuVLBx57KejMdqQYJCkbv6TAg0/LCQNxmomgVGD
// SIG // ShC7dWNEqmkIxgPr4s8L7VY67O9ypwoM9ADTIrivInKz
// SIG // 58ScCyiggMrj4dc5ZjDnRhcY5/qC+lkLeryoDf4c/wOL
// SIG // Y7JNEgIjTy2zhYQ74qFH6M8VMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAALARrwqL0Duf3QABAAAAsDANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xMzAx
// SIG // MjQyMjMzMzlaFw0xNDA0MjQyMjMzMzlaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDor1yiIA34
// SIG // KHy8BXt/re7rdqwoUz8620B9s44z5lc/pVEVNFSlz7SL
// SIG // qT+oN+EtUO01Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Un
// SIG // m/P4LZ5BNisLQPu+O7q5XHWTFlJLyjPFN7Dz636o9UEV
// SIG // XAhlHSE38Cy6IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpO
// SIG // oPXJCiHiquMBNkf9L4JqgQP1qTXclFed+0vUDoLbOI8S
// SIG // /uPWenSIZOFixCUuKq6dGB8OHrbCryS0DlC83hyTXEmm
// SIG // ebW22875cHsoAYS4KinPv6kFBeHgD3FN/a1cI4Mp68fF
// SIG // SsjoJ4TTfsZDC5UABbFPZXHFAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGm
// SIG // WjNN2pgHgP+EHr6H+XIyQfIwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRm
// SIG // YWYwYjcxLWFkMzctNGFhMy1hNjcxLTc2YmMwNTIzNDRh
// SIG // ZDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEAMdduKhJXM4HVncbr+TrURE0Inu5e32pbt3nPApy8
// SIG // dmiekKGcC8N/oozxTbqVOfsN4OGb9F0kDxuNiBU6fNut
// SIG // zrPJbLo5LEV9JBFUJjANDf9H6gMH5eRmXSx7nR2pEPoc
// SIG // sHTyT2lrnqkkhNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2y
// SIG // RPnwPJNtQtjofOYXoJtoaAko+QKX7xEDumdSrcHps3Om
// SIG // 0mPNSuI+5PNO/f+h4LsCEztdIN5VP6OukEAxOHUoXgSp
// SIG // Rm3m9Xp5QL0fzehF1a7iXT71dcfmZmNgzNWahIeNJDD3
// SIG // 7zTQYx2xQmdKDku/Og7vtpU6pzjkJZIIpohmgjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggSVMIIEkQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAALARrwqL0Duf3QAB
// SIG // AAAAsDAJBgUrDgMCGgUAoIGuMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBQQFPYFibV0
// SIG // gKl9v/Xw5phhvukcJDBOBgorBgEEAYI3AgEMMUAwPqAk
// SIG // gCIARABpAGEAZwBuAG8AcwB0AGkAYwBzAEgAdQBiAC4A
// SIG // agBzoRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqG
// SIG // SIb3DQEBAQUABIIBACNix0zFmAOnM+uGpyyiT92OejTt
// SIG // jUVx5NieR+Ts8EDmqeLeoiQNI9EhhbC2qVEwYHcOyrQk
// SIG // MhtYd8Vj6q4E5kTCHT2cjNhYZkF6J8Lv8r68WyAqIgmq
// SIG // fi80Guk0eNMPQCPDpkfJOsjY2AFexwwwivHdrzgIFlX5
// SIG // +xZri9nerZlfhbGNjWZbT+iU7TmpylZ46sBvFumQnCnz
// SIG // lAZC9LZhZgKiDefNEvpySxVKArfi9dgQX5Ek9JQoUEwi
// SIG // n2TRFzUWwyQSL7IgNpViyvNhkWMrg8CYR42ikQqqaUcI
// SIG // fZvx3E2Q8t4SYCgBNMjDo9gUwISjEnRUPBmZyZ1nR2Jc
// SIG // nwGUORShggIoMIICJAYJKoZIhvcNAQkGMYICFTCCAhEC
// SIG // AQEwgY4wdzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UE
// SIG // AxMYTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBAhMzAAAA
// SIG // KzkySMGyyUjzAAAAAAArMAkGBSsOAwIaBQCgXTAYBgkq
// SIG // hkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJ
// SIG // BTEPFw0xMzAzMTUwNjMzNTVaMCMGCSqGSIb3DQEJBDEW
// SIG // BBS0RyiiqROXLli97lzC2CnhzthG7zANBgkqhkiG9w0B
// SIG // AQUFAASCAQAuKGkYafiUvDjTH/nKo6+KrdRlxeOvbcWI
// SIG // GEeFqBAoX98eRuCihmo2iEqSbkUMP8pd2VN1RYKoLHMv
// SIG // D+tHUjzaC0ye1IYKUmhHhjyZBAaMumjLjryEEpvSB7Sm
// SIG // 8Zz6mcAWxA5bgZrqc9ctkuE87myHjfc8TWE8MGObegI2
// SIG // RVh+UgmG8rAc0yPAed4UVgC5pI5t1DTL8l5sISKuelnT
// SIG // JBigHXi/XRYAEiIjNFxNg7DHJC2SYssW/oGAfptf/Y+p
// SIG // gId18GIHurGxgxUbAI7yUKJssQ5Ec1vImq/mtCkgmW1x
// SIG // Yix4TKP3biTGdg4YsczxliilIqlFMylMW4k6zHbNtP48
// SIG // End signature block
